@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Additional information about Azure File Share backup item.
 * @property oldestRecoveryPoint The oldest backup copy available for this item in the service.
 * @property policyState Indicates consistency of policy object and policy applied to this backup item.
 * @property recoveryPointCount Number of available backup copies associated with this backup item.
 * @property resourceState Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted, Deleted}
 * @property resourceStateSyncTime The resource state sync time for this backup item.
 */
public data class AzureFileshareProtectedItemExtendedInfoResponse(
    public val oldestRecoveryPoint: String? = null,
    public val policyState: String? = null,
    public val recoveryPointCount: Int? = null,
    public val resourceState: String,
    public val resourceStateSyncTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureFileshareProtectedItemExtendedInfoResponse): AzureFileshareProtectedItemExtendedInfoResponse =
            AzureFileshareProtectedItemExtendedInfoResponse(
                oldestRecoveryPoint = javaType.oldestRecoveryPoint().map({ args0 -> args0 }).orElse(null),
                policyState = javaType.policyState().map({ args0 -> args0 }).orElse(null),
                recoveryPointCount = javaType.recoveryPointCount().map({ args0 -> args0 }).orElse(null),
                resourceState = javaType.resourceState(),
                resourceStateSyncTime = javaType.resourceStateSyncTime(),
            )
    }
}
