@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'Microsoft.Compute/virtualMachines'.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property resourceGroup Resource group name of Recovery Services Vault.
 * @property virtualMachineId Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
 * @property virtualMachineVersion Specifies whether the container represents a Classic or an Azure Resource Manager VM.
 */
public data class AzureIaaSComputeVMContainerResponse(
    public val backupManagementType: String? = null,
    public val containerType: String,
    public val friendlyName: String? = null,
    public val healthStatus: String? = null,
    public val protectableObjectType: String? = null,
    public val registrationStatus: String? = null,
    public val resourceGroup: String? = null,
    public val virtualMachineId: String? = null,
    public val virtualMachineVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureIaaSComputeVMContainerResponse): AzureIaaSComputeVMContainerResponse = AzureIaaSComputeVMContainerResponse(
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            containerType = javaType.containerType(),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            protectableObjectType = javaType.protectableObjectType().map({ args0 -> args0 }).orElse(null),
            registrationStatus = javaType.registrationStatus().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            virtualMachineId = javaType.virtualMachineId().map({ args0 -> args0 }).orElse(null),
            virtualMachineVersion = javaType.virtualMachineVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
