@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure IaaS VM workload-specific Health Details.
 * @property code Health Code
 * @property message Health Message
 * @property recommendations Health Recommended Actions
 * @property title Health Title
 */
public data class AzureIaaSVMHealthDetailsResponse(
    public val code: Int,
    public val message: String,
    public val recommendations: List<String>,
    public val title: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureIaaSVMHealthDetailsResponse): AzureIaaSVMHealthDetailsResponse = AzureIaaSVMHealthDetailsResponse(
            code = javaType.code(),
            message = javaType.message(),
            recommendations = javaType.recommendations().map({ args0 -> args0 }),
            title = javaType.title(),
        )
    }
}
