@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * IaaS VM workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureIaasVM'.
 * @property instantRPDetails
 * @property instantRpRetentionRangeInDays Instant RP retention policy range in days
 * @property policyType
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property tieringPolicy Tiering policy to automatically move RPs to another tier
 * Key is Target Tier, defined in RecoveryPointTierType enum.
 * Tiering policy specifies the criteria to move RP to the target tier.
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 */
public data class AzureIaaSVMProtectionPolicyResponse(
    public val backupManagementType: String,
    public val instantRPDetails: InstantRPAdditionalDetailsResponse? = null,
    public val instantRpRetentionRangeInDays: Int? = null,
    public val policyType: String? = null,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val retentionPolicy: Either<LongTermRetentionPolicyResponse, SimpleRetentionPolicyResponse>? = null,
    public val schedulePolicy: Any? = null,
    public val tieringPolicy: Map<String, TieringPolicyResponse>? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureIaaSVMProtectionPolicyResponse): AzureIaaSVMProtectionPolicyResponse = AzureIaaSVMProtectionPolicyResponse(
            backupManagementType = javaType.backupManagementType(),
            instantRPDetails = javaType.instantRPDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InstantRPAdditionalDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instantRpRetentionRangeInDays = javaType.instantRpRetentionRangeInDays().map({ args0 ->
                args0
            }).orElse(null),
            policyType = javaType.policyType().map({ args0 -> args0 }).orElse(null),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.LongTermRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.SimpleRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            schedulePolicy = javaType.schedulePolicy().map({ args0 -> args0 }).orElse(null),
            tieringPolicy = javaType.tieringPolicy().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.TieringPolicyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
