@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Additional information on Azure Sql specific protected item.
 * @property oldestRecoveryPoint The oldest backup copy available for this item in the service.
 * @property policyState State of the backup policy associated with this backup item.
 * @property recoveryPointCount Number of available backup copies associated with this backup item.
 */
public data class AzureSqlProtectedItemExtendedInfoResponse(
    public val oldestRecoveryPoint: String? = null,
    public val policyState: String? = null,
    public val recoveryPointCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureSqlProtectedItemExtendedInfoResponse): AzureSqlProtectedItemExtendedInfoResponse = AzureSqlProtectedItemExtendedInfoResponse(
            oldestRecoveryPoint = javaType.oldestRecoveryPoint().map({ args0 -> args0 }).orElse(null),
            policyState = javaType.policyState().map({ args0 -> args0 }).orElse(null),
            recoveryPointCount = javaType.recoveryPointCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
