@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure SQL workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureSql'.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy details.
 */
public data class AzureSqlProtectionPolicyResponse(
    public val backupManagementType: String,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val retentionPolicy: Either<LongTermRetentionPolicyResponse, SimpleRetentionPolicyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureSqlProtectionPolicyResponse): AzureSqlProtectionPolicyResponse = AzureSqlProtectionPolicyResponse(
            backupManagementType = javaType.backupManagementType(),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.LongTermRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.SimpleRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
        )
    }
}
