@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A2A Network Mapping fabric specific settings.
 * @property instanceType Gets the Instance type.
 * Expected value is 'AzureToAzure'.
 * @property primaryFabricLocation The primary fabric location.
 * @property recoveryFabricLocation The recovery fabric location.
 */
public data class AzureToAzureNetworkMappingSettingsResponse(
    public val instanceType: String,
    public val primaryFabricLocation: String? = null,
    public val recoveryFabricLocation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureToAzureNetworkMappingSettingsResponse): AzureToAzureNetworkMappingSettingsResponse = AzureToAzureNetworkMappingSettingsResponse(
            instanceType = javaType.instanceType(),
            primaryFabricLocation = javaType.primaryFabricLocation().map({ args0 -> args0 }).orElse(null),
            recoveryFabricLocation = javaType.recoveryFabricLocation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
