@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure to Azure VM synced configuration details.
 * @property inputEndpoints The Azure VM input endpoints.
 * @property tags The Azure VM tags.
 */
public data class AzureToAzureVmSyncedConfigDetailsResponse(
    public val inputEndpoints: List<InputEndpointResponse>? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureToAzureVmSyncedConfigDetailsResponse): AzureToAzureVmSyncedConfigDetailsResponse = AzureToAzureVmSyncedConfigDetailsResponse(
            inputEndpoints = javaType.inputEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InputEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
