@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container for SQL workloads under Azure Virtual Machines.
 * @property backupManagementType Type of backup management for the container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'VMAppContainer'.
 * @property extendedInfo Additional details of a workload container.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property lastUpdatedTime Time stamp when this container was updated.
 * @property operationType Re-Do Operation
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property sourceResourceId ARM ID of the virtual machine represented by this Azure Workload Container
 * @property workloadType Workload type for which registration was sent.
 */
public data class AzureVMAppContainerProtectionContainerResponse(
    public val backupManagementType: String? = null,
    public val containerType: String,
    public val extendedInfo: AzureWorkloadContainerExtendedInfoResponse? = null,
    public val friendlyName: String? = null,
    public val healthStatus: String? = null,
    public val lastUpdatedTime: String? = null,
    public val operationType: String? = null,
    public val protectableObjectType: String? = null,
    public val registrationStatus: String? = null,
    public val sourceResourceId: String? = null,
    public val workloadType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureVMAppContainerProtectionContainerResponse): AzureVMAppContainerProtectionContainerResponse =
            AzureVMAppContainerProtectionContainerResponse(
                backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
                containerType = javaType.containerType(),
                extendedInfo = javaType.extendedInfo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.AzureWorkloadContainerExtendedInfoResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
                healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
                lastUpdatedTime = javaType.lastUpdatedTime().map({ args0 -> args0 }).orElse(null),
                operationType = javaType.operationType().map({ args0 -> args0 }).orElse(null),
                protectableObjectType = javaType.protectableObjectType().map({ args0 -> args0 }).orElse(null),
                registrationStatus = javaType.registrationStatus().map({ args0 -> args0 }).orElse(null),
                sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
                workloadType = javaType.workloadType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
