@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Additional information on Azure Workload for SQL specific backup item.
 * @property newestRecoveryPointInArchive The latest backup copy available for this backup item in archive tier
 * @property oldestRecoveryPoint The oldest backup copy available for this backup item across all tiers.
 * @property oldestRecoveryPointInArchive The oldest backup copy available for this backup item in archive tier
 * @property oldestRecoveryPointInVault The oldest backup copy available for this backup item in vault tier
 * @property policyState Indicates consistency of policy object and policy applied to this backup item.
 * @property recoveryModel Indicates consistency of policy object and policy applied to this backup item.
 * @property recoveryPointCount Number of backup copies available for this backup item.
 */
public data class AzureVmWorkloadProtectedItemExtendedInfoResponse(
    public val newestRecoveryPointInArchive: String? = null,
    public val oldestRecoveryPoint: String? = null,
    public val oldestRecoveryPointInArchive: String? = null,
    public val oldestRecoveryPointInVault: String? = null,
    public val policyState: String? = null,
    public val recoveryModel: String? = null,
    public val recoveryPointCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureVmWorkloadProtectedItemExtendedInfoResponse): AzureVmWorkloadProtectedItemExtendedInfoResponse =
            AzureVmWorkloadProtectedItemExtendedInfoResponse(
                newestRecoveryPointInArchive = javaType.newestRecoveryPointInArchive().map({ args0 ->
                    args0
                }).orElse(null),
                oldestRecoveryPoint = javaType.oldestRecoveryPoint().map({ args0 -> args0 }).orElse(null),
                oldestRecoveryPointInArchive = javaType.oldestRecoveryPointInArchive().map({ args0 ->
                    args0
                }).orElse(null),
                oldestRecoveryPointInVault = javaType.oldestRecoveryPointInVault().map({ args0 ->
                    args0
                }).orElse(null),
                policyState = javaType.policyState().map({ args0 -> args0 }).orElse(null),
                recoveryModel = javaType.recoveryModel().map({ args0 -> args0 }).orElse(null),
                recoveryPointCount = javaType.recoveryPointCount().map({ args0 -> args0 }).orElse(null),
            )
    }
}
