@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Extended information of the container.
 * @property hostServerName Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
 * @property inquiryInfo Inquiry Status for the container.
 * @property nodesList List of the nodes in case of distributed container.
 */
public data class AzureWorkloadContainerExtendedInfoResponse(
    public val hostServerName: String? = null,
    public val inquiryInfo: InquiryInfoResponse? = null,
    public val nodesList: List<DistributedNodesInfoResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureWorkloadContainerExtendedInfoResponse): AzureWorkloadContainerExtendedInfoResponse = AzureWorkloadContainerExtendedInfoResponse(
            hostServerName = javaType.hostServerName().map({ args0 -> args0 }).orElse(null),
            inquiryInfo = javaType.inquiryInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InquiryInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nodesList = javaType.nodesList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DistributedNodesInfoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
