@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The details of the identity used for CMK
 * @property useSystemAssignedIdentity Indicate that system assigned identity should be used. Mutually exclusive with 'userAssignedIdentity' field
 * @property userAssignedIdentity The user assigned identity to be used to grant permissions in case the type of identity used is UserAssigned
 */
public data class CmkKekIdentityResponse(
    public val useSystemAssignedIdentity: Boolean? = null,
    public val userAssignedIdentity: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.CmkKekIdentityResponse): CmkKekIdentityResponse = CmkKekIdentityResponse(
            useSystemAssignedIdentity = javaType.useSystemAssignedIdentity().map({ args0 ->
                args0
            }).orElse(null),
            userAssignedIdentity = javaType.userAssignedIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
