@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the Key Vault which hosts CMK
 * @property keyUri The key uri of the Customer Managed Key
 */
public data class CmkKeyVaultPropertiesResponse(
    public val keyUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.CmkKeyVaultPropertiesResponse): CmkKeyVaultPropertiesResponse = CmkKeyVaultPropertiesResponse(
            keyUri = javaType.keyUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
