@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Additional information of DPM Protected item.
 * @property diskStorageUsedInBytes Used Disk storage in bytes.
 * @property isCollocated To check if backup item is collocated.
 * @property isPresentOnCloud To check if backup item is cloud protected.
 * @property lastBackupStatus Last backup status information on backup item.
 * @property lastRefreshedAt Last refresh time on backup item.
 * @property oldestRecoveryPoint Oldest cloud recovery point time.
 * @property onPremiseLatestRecoveryPoint latest disk recovery point time.
 * @property onPremiseOldestRecoveryPoint Oldest disk recovery point time.
 * @property onPremiseRecoveryPointCount disk recovery point count.
 * @property protectableObjectLoadPath Attribute to provide information on various DBs.
 * @property protected To check if backup item is disk protected.
 * @property protectionGroupName Protection group name of the backup item.
 * @property recoveryPointCount cloud recovery point count.
 * @property totalDiskStorageSizeInBytes total Disk storage in bytes.
 */
public data class DPMProtectedItemExtendedInfoResponse(
    public val diskStorageUsedInBytes: String? = null,
    public val isCollocated: Boolean? = null,
    public val isPresentOnCloud: Boolean? = null,
    public val lastBackupStatus: String? = null,
    public val lastRefreshedAt: String? = null,
    public val oldestRecoveryPoint: String? = null,
    public val onPremiseLatestRecoveryPoint: String? = null,
    public val onPremiseOldestRecoveryPoint: String? = null,
    public val onPremiseRecoveryPointCount: Int? = null,
    public val protectableObjectLoadPath: Map<String, String>? = null,
    public val `protected`: Boolean? = null,
    public val protectionGroupName: String? = null,
    public val recoveryPointCount: Int? = null,
    public val totalDiskStorageSizeInBytes: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DPMProtectedItemExtendedInfoResponse): DPMProtectedItemExtendedInfoResponse = DPMProtectedItemExtendedInfoResponse(
            diskStorageUsedInBytes = javaType.diskStorageUsedInBytes().map({ args0 -> args0 }).orElse(null),
            isCollocated = javaType.isCollocated().map({ args0 -> args0 }).orElse(null),
            isPresentOnCloud = javaType.isPresentOnCloud().map({ args0 -> args0 }).orElse(null),
            lastBackupStatus = javaType.lastBackupStatus().map({ args0 -> args0 }).orElse(null),
            lastRefreshedAt = javaType.lastRefreshedAt().map({ args0 -> args0 }).orElse(null),
            oldestRecoveryPoint = javaType.oldestRecoveryPoint().map({ args0 -> args0 }).orElse(null),
            onPremiseLatestRecoveryPoint = javaType.onPremiseLatestRecoveryPoint().map({ args0 ->
                args0
            }).orElse(null),
            onPremiseOldestRecoveryPoint = javaType.onPremiseOldestRecoveryPoint().map({ args0 ->
                args0
            }).orElse(null),
            onPremiseRecoveryPointCount = javaType.onPremiseRecoveryPointCount().map({ args0 ->
                args0
            }).orElse(null),
            protectableObjectLoadPath = javaType.protectableObjectLoadPath().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            `protected` = javaType.protected_().map({ args0 -> args0 }).orElse(null),
            protectionGroupName = javaType.protectionGroupName().map({ args0 -> args0 }).orElse(null),
            recoveryPointCount = javaType.recoveryPointCount().map({ args0 -> args0 }).orElse(null),
            totalDiskStorageSizeInBytes = javaType.totalDiskStorageSizeInBytes().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
