@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Additional information on Backup engine specific backup item.
 * @property backupEngineName Backup Management server protecting this backup item
 * @property backupManagementType Type of backup management for the backed up item.
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property extendedInfo Extended info of the backup item.
 * @property friendlyName Friendly name of the managed item
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property protectedItemType backup item type.
 * Expected value is 'DPMProtectedItem'.
 * @property protectionState Protection state of the backup engine
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceResourceId ARM ID of the resource to be backed up.
 * @property vaultId ID of the vault which protects this item
 * @property workloadType Type of workload this item represents.
 */
public data class DPMProtectedItemResponse(
    public val backupEngineName: String? = null,
    public val backupManagementType: String,
    public val backupSetName: String? = null,
    public val containerName: String? = null,
    public val createMode: String? = null,
    public val deferredDeleteTimeInUTC: String? = null,
    public val deferredDeleteTimeRemaining: String? = null,
    public val extendedInfo: DPMProtectedItemExtendedInfoResponse? = null,
    public val friendlyName: String? = null,
    public val isArchiveEnabled: Boolean? = null,
    public val isDeferredDeleteScheduleUpcoming: Boolean? = null,
    public val isRehydrate: Boolean? = null,
    public val isScheduledForDeferredDelete: Boolean? = null,
    public val lastRecoveryPoint: String? = null,
    public val policyId: String? = null,
    public val policyName: String? = null,
    public val protectedItemType: String,
    public val protectionState: String? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val softDeleteRetentionPeriodInDays: Int? = null,
    public val sourceResourceId: String? = null,
    public val vaultId: String,
    public val workloadType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DPMProtectedItemResponse): DPMProtectedItemResponse = DPMProtectedItemResponse(
            backupEngineName = javaType.backupEngineName().map({ args0 -> args0 }).orElse(null),
            backupManagementType = javaType.backupManagementType(),
            backupSetName = javaType.backupSetName().map({ args0 -> args0 }).orElse(null),
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            createMode = javaType.createMode().map({ args0 -> args0 }).orElse(null),
            deferredDeleteTimeInUTC = javaType.deferredDeleteTimeInUTC().map({ args0 -> args0 }).orElse(null),
            deferredDeleteTimeRemaining = javaType.deferredDeleteTimeRemaining().map({ args0 ->
                args0
            }).orElse(null),
            extendedInfo = javaType.extendedInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DPMProtectedItemExtendedInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            isArchiveEnabled = javaType.isArchiveEnabled().map({ args0 -> args0 }).orElse(null),
            isDeferredDeleteScheduleUpcoming = javaType.isDeferredDeleteScheduleUpcoming().map({ args0 ->
                args0
            }).orElse(null),
            isRehydrate = javaType.isRehydrate().map({ args0 -> args0 }).orElse(null),
            isScheduledForDeferredDelete = javaType.isScheduledForDeferredDelete().map({ args0 ->
                args0
            }).orElse(null),
            lastRecoveryPoint = javaType.lastRecoveryPoint().map({ args0 -> args0 }).orElse(null),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            protectedItemType = javaType.protectedItemType(),
            protectionState = javaType.protectionState().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            softDeleteRetentionPeriodInDays = javaType.softDeleteRetentionPeriodInDays().map({ args0 ->
                args0
            }).orElse(null),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            vaultId = javaType.vaultId(),
            workloadType = javaType.workloadType(),
        )
    }
}
