@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Daily retention schedule.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class DailyRetentionScheduleResponse(
    public val retentionDuration: RetentionDurationResponse? = null,
    public val retentionTimes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DailyRetentionScheduleResponse): DailyRetentionScheduleResponse = DailyRetentionScheduleResponse(
            retentionDuration = javaType.retentionDuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RetentionDurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionTimes = javaType.retentionTimes().map({ args0 -> args0 }),
        )
    }
}
