@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The datastore details of the MT.
 * @property capacity The capacity of data store in GBs.
 * @property freeSpace The free space of data store in GBs.
 * @property symbolicName The symbolic name of data store.
 * @property type The type of data store.
 * @property uuid The uuid of data store.
 */
public data class DataStoreResponse(
    public val capacity: String? = null,
    public val freeSpace: String? = null,
    public val symbolicName: String? = null,
    public val type: String? = null,
    public val uuid: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DataStoreResponse): DataStoreResponse = DataStoreResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            freeSpace = javaType.freeSpace().map({ args0 -> args0 }).orElse(null),
            symbolicName = javaType.symbolicName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            uuid = javaType.uuid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
