@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Onprem disk details data.
 * @property maxSizeMB The hard disk max size in MB.
 * @property vhdId The VHD Id.
 * @property vhdName The VHD name.
 * @property vhdType The type of the volume.
 */
public data class DiskDetailsResponse(
    public val maxSizeMB: Double? = null,
    public val vhdId: String? = null,
    public val vhdName: String? = null,
    public val vhdType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DiskDetailsResponse): DiskDetailsResponse = DiskDetailsResponse(
            maxSizeMB = javaType.maxSizeMB().map({ args0 -> args0 }).orElse(null),
            vhdId = javaType.vhdId().map({ args0 -> args0 }).orElse(null),
            vhdName = javaType.vhdName().map({ args0 -> args0 }).orElse(null),
            vhdType = javaType.vhdType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
