@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DRA details.
 * @property biosId The DRA Bios Id.
 * @property forwardProtectedItemCount The count of protected items which are protected in forward direction.
 * @property health The health.
 * @property healthErrors The health errors.
 * @property id The DRA Id.
 * @property lastHeartbeatUtc The last heartbeat received from the DRA.
 * @property name The DRA name.
 * @property reverseProtectedItemCount The count of protected items which are protected in reverse direction.
 * @property version The version.
 */
public data class DraDetailsResponse(
    public val biosId: String,
    public val forwardProtectedItemCount: Int,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val id: String,
    public val lastHeartbeatUtc: String,
    public val name: String,
    public val reverseProtectedItemCount: Int,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DraDetailsResponse): DraDetailsResponse = DraDetailsResponse(
            biosId = javaType.biosId(),
            forwardProtectedItemCount = javaType.forwardProtectedItemCount(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            name = javaType.name(),
            reverseProtectedItemCount = javaType.reverseProtectedItemCount(),
            version = javaType.version(),
        )
    }
}
