@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Encryption details for the fabric.
 * @property kekCertExpiryDate The key encryption key certificate expiry date.
 * @property kekCertThumbprint The key encryption key certificate thumbprint.
 * @property kekState The key encryption key state for the Vmm.
 */
public data class EncryptionDetailsResponse(
    public val kekCertExpiryDate: String? = null,
    public val kekCertThumbprint: String? = null,
    public val kekState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.EncryptionDetailsResponse): EncryptionDetailsResponse = EncryptionDetailsResponse(
            kekCertExpiryDate = javaType.kekCertExpiryDate().map({ args0 -> args0 }).orElse(null),
            kekCertThumbprint = javaType.kekCertThumbprint().map({ args0 -> args0 }).orElse(null),
            kekState = javaType.kekState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
