@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Error Detail class which encapsulates Code, Message and Recommendations.
 * @property code Error code.
 * @property message Error Message related to the Code.
 * @property recommendations List of recommendation strings.
 */
public data class ErrorDetailResponse(
    public val code: String,
    public val message: String,
    public val recommendations: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ErrorDetailResponse): ErrorDetailResponse = ErrorDetailResponse(
            code = javaType.code(),
            message = javaType.message(),
            recommendations = javaType.recommendations().map({ args0 -> args0 }),
        )
    }
}
