@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extended Properties for Azure IaasVM Backup.
 * @property diskExclusionProperties Extended Properties for Disk Exclusion.
 * @property linuxVmApplicationName Linux VM name
 */
public data class ExtendedPropertiesResponse(
    public val diskExclusionProperties: DiskExclusionPropertiesResponse? = null,
    public val linuxVmApplicationName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ExtendedPropertiesResponse): ExtendedPropertiesResponse = ExtendedPropertiesResponse(
            diskExclusionProperties = javaType.diskExclusionProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DiskExclusionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            linuxVmApplicationName = javaType.linuxVmApplicationName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
