@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Azure VM (Mercury) workload-specific backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'GenericProtectionPolicy'.
 * @property fabricName Name of this policy's fabric.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property subProtectionPolicy List of sub-protection policies which includes schedule and retention
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 */
public data class GenericProtectionPolicyResponse(
    public val backupManagementType: String,
    public val fabricName: String? = null,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val subProtectionPolicy: List<SubProtectionPolicyResponse>? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GenericProtectionPolicyResponse): GenericProtectionPolicyResponse = GenericProtectionPolicyResponse(
            backupManagementType = javaType.backupManagementType(),
            fabricName = javaType.fabricName().map({ args0 -> args0 }).orElse(null),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            subProtectionPolicy = javaType.subProtectionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.SubProtectionPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
