@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Private Endpoint Connection Response Properties
 * @property eTag Optional ETag.
 * @property id Resource Id represents the complete path to the resource.
 * @property location Resource location.
 * @property name Resource name associated with the resource.
 * @property properties PrivateEndpointConnectionResource properties
 * @property tags Resource tags.
 * @property type Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
 */
public data class GetPrivateEndpointConnectionResult(
    public val eTag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: PrivateEndpointConnectionResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GetPrivateEndpointConnectionResult): GetPrivateEndpointConnectionResult = GetPrivateEndpointConnectionResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
