@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Base class for backup policy. Workload-specific backup policies are derived from this class.
 * @property eTag Optional ETag.
 * @property id Resource Id represents the complete path to the resource.
 * @property location Resource location.
 * @property name Resource name associated with the resource.
 * @property properties ProtectionPolicyResource properties
 * @property tags Resource tags.
 * @property type Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
 */
public data class GetProtectionPolicyResult(
    public val eTag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: Any,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GetProtectionPolicyResult): GetProtectionPolicyResult = GetProtectionPolicyResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
