@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.
 * @property id Resource Id
 * @property location Resource Location
 * @property name Resource Name
 * @property properties The Network Mapping Properties.
 * @property type Resource Type
 */
public data class GetReplicationNetworkMappingResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: NetworkMappingPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GetReplicationNetworkMappingResult): GetReplicationNetworkMappingResult = GetReplicationNetworkMappingResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.NetworkMappingPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
