@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Replication protection Cluster.
 * @property id The protection cluster Id.
 * @property name The name of the protection cluster.
 * @property properties The custom data.
 * @property type The Type of the object.
 */
public data class GetReplicationProtectionClusterResult(
    public val id: String,
    public val name: String,
    public val properties: ReplicationProtectionClusterPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GetReplicationProtectionClusterResult): GetReplicationProtectionClusterResult = GetReplicationProtectionClusterResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReplicationProtectionClusterPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
