@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource information, as returned by the resource provider.
 * @property etag Optional ETag.
 * @property id Resource Id represents the complete path to the resource.
 * @property identity Identity for the resource.
 * @property location Resource location.
 * @property name Resource name associated with the resource.
 * @property properties Properties of the vault.
 * @property sku Identifies the unique system identifier for each Azure resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
 */
public data class GetVaultResult(
    public val etag: String? = null,
    public val id: String,
    public val identity: IdentityDataResponse? = null,
    public val location: String,
    public val name: String,
    public val properties: VaultPropertiesResponse,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GetVaultResult): GetVaultResult = GetVaultResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.IdentityDataResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.VaultPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.recoveryservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
