@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Health Error.
 * @property creationTimeUtc Error creation time (UTC).
 * @property customerResolvability Value indicating whether the health error is customer resolvable.
 * @property entityId ID of the entity.
 * @property errorCategory Category of error.
 * @property errorCode Error code.
 * @property errorId The health error unique id.
 * @property errorLevel Level of error.
 * @property errorMessage Error message.
 * @property errorSource Source of error.
 * @property errorType Type of error.
 * @property innerHealthErrors The inner health errors. HealthError having a list of HealthError as child errors is problematic. InnerHealthError is used because this will prevent an infinite loop of structures when Hydra tries to auto-generate the contract. We are exposing the related health errors as inner health errors and all API consumers can utilize this in the same fashion as Exception -&gt; InnerException.
 * @property possibleCauses Possible causes of error.
 * @property recommendedAction Recommended action to resolve error.
 * @property recoveryProviderErrorMessage DRA error message.
 * @property summaryMessage Summary message of the entity.
 */
public data class HealthErrorResponse(
    public val creationTimeUtc: String? = null,
    public val customerResolvability: String? = null,
    public val entityId: String? = null,
    public val errorCategory: String? = null,
    public val errorCode: String? = null,
    public val errorId: String? = null,
    public val errorLevel: String? = null,
    public val errorMessage: String? = null,
    public val errorSource: String? = null,
    public val errorType: String? = null,
    public val innerHealthErrors: List<InnerHealthErrorResponse>? = null,
    public val possibleCauses: String? = null,
    public val recommendedAction: String? = null,
    public val recoveryProviderErrorMessage: String? = null,
    public val summaryMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HealthErrorResponse): HealthErrorResponse = HealthErrorResponse(
            creationTimeUtc = javaType.creationTimeUtc().map({ args0 -> args0 }).orElse(null),
            customerResolvability = javaType.customerResolvability().map({ args0 -> args0 }).orElse(null),
            entityId = javaType.entityId().map({ args0 -> args0 }).orElse(null),
            errorCategory = javaType.errorCategory().map({ args0 -> args0 }).orElse(null),
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorId = javaType.errorId().map({ args0 -> args0 }).orElse(null),
            errorLevel = javaType.errorLevel().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            errorSource = javaType.errorSource().map({ args0 -> args0 }).orElse(null),
            errorType = javaType.errorType().map({ args0 -> args0 }).orElse(null),
            innerHealthErrors = javaType.innerHealthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InnerHealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            possibleCauses = javaType.possibleCauses().map({ args0 -> args0 }).orElse(null),
            recommendedAction = javaType.recommendedAction().map({ args0 -> args0 }).orElse(null),
            recoveryProviderErrorMessage = javaType.recoveryProviderErrorMessage().map({ args0 ->
                args0
            }).orElse(null),
            summaryMessage = javaType.summaryMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
