@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property interval Interval at which backup needs to be triggered. For hourly the value
 *  can be 4/6/8/12
 * @property scheduleWindowDuration To specify duration of the backup window
 * @property scheduleWindowStartTime To specify start time of the backup window
 */
public data class HourlyScheduleResponse(
    public val interval: Int? = null,
    public val scheduleWindowDuration: Int? = null,
    public val scheduleWindowStartTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HourlyScheduleResponse): HourlyScheduleResponse = HourlyScheduleResponse(
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            scheduleWindowDuration = javaType.scheduleWindowDuration().map({ args0 -> args0 }).orElse(null),
            scheduleWindowStartTime = javaType.scheduleWindowStartTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
