@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Hyper-V Managed disk details.
 * @property diskEncryptionSetId The disk encryption set ARM Id.
 * @property diskId The disk Id.
 * @property replicaDiskType The replica disk type.
 * @property seedManagedDiskId Seed managed disk Id.
 */
public data class HyperVReplicaAzureManagedDiskDetailsResponse(
    public val diskEncryptionSetId: String? = null,
    public val diskId: String? = null,
    public val replicaDiskType: String? = null,
    public val seedManagedDiskId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVReplicaAzureManagedDiskDetailsResponse): HyperVReplicaAzureManagedDiskDetailsResponse = HyperVReplicaAzureManagedDiskDetailsResponse(
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            replicaDiskType = javaType.replicaDiskType().map({ args0 -> args0 }).orElse(null),
            seedManagedDiskId = javaType.seedManagedDiskId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
