@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Hyper-V Replica Azure specific protection profile details.
 * @property activeStorageAccountId The active storage account Id.
 * @property applicationConsistentSnapshotFrequencyInHours The interval (in hours) at which Hyper-V Replica should create an application consistent snapshot within the VM.
 * @property encryption A value indicating whether encryption is enabled for virtual machines in this cloud.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'HyperVReplicaAzure'.
 * @property onlineReplicationStartTime The scheduled start time for the initial replication. If this parameter is Null, the initial replication starts immediately.
 * @property recoveryPointHistoryDurationInHours The duration (in hours) to which point the recovery history needs to be maintained.
 * @property replicationInterval The replication interval.
 */
public data class HyperVReplicaAzurePolicyDetailsResponse(
    public val activeStorageAccountId: String? = null,
    public val applicationConsistentSnapshotFrequencyInHours: Int? = null,
    public val encryption: String? = null,
    public val instanceType: String,
    public val onlineReplicationStartTime: String? = null,
    public val recoveryPointHistoryDurationInHours: Int? = null,
    public val replicationInterval: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVReplicaAzurePolicyDetailsResponse): HyperVReplicaAzurePolicyDetailsResponse = HyperVReplicaAzurePolicyDetailsResponse(
            activeStorageAccountId = javaType.activeStorageAccountId().map({ args0 -> args0 }).orElse(null),
            applicationConsistentSnapshotFrequencyInHours = javaType.applicationConsistentSnapshotFrequencyInHours().map({ args0 ->
                args0
            }).orElse(null),
            encryption = javaType.encryption().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            onlineReplicationStartTime = javaType.onlineReplicationStartTime().map({ args0 ->
                args0
            }).orElse(null),
            recoveryPointHistoryDurationInHours = javaType.recoveryPointHistoryDurationInHours().map({ args0 ->
                args0
            }).orElse(null),
            replicationInterval = javaType.replicationInterval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
