@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Hyper V Replica Azure provider specific settings.
 * @property azureVmDiskDetails Azure VM Disk details.
 * @property enableRdpOnTargetOption The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
 * @property encryption The encryption info.
 * @property initialReplicationDetails Initial replication details.
 * @property instanceType Gets the Instance type.
 * Expected value is 'HyperVReplicaAzure'.
 * @property lastRecoveryPointReceived The last recovery point received time.
 * @property lastReplicatedTime The Last replication time.
 * @property lastRpoCalculatedTime The last RPO calculated time.
 * @property licenseType License Type of the VM to be used.
 * @property oSDetails The operating system info.
 * @property protectedManagedDisks The list of protected managed disks.
 * @property recoveryAvailabilitySetId The recovery availability set Id.
 * @property recoveryAzureLogStorageAccountId The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
 * @property recoveryAzureResourceGroupId The target resource group Id.
 * @property recoveryAzureStorageAccount The recovery Azure storage account.
 * @property recoveryAzureVMSize The Recovery Azure VM size.
 * @property recoveryAzureVmName Recovery Azure given name.
 * @property rpoInSeconds Last RPO value.
 * @property seedManagedDiskTags The tags for the seed managed disks.
 * @property selectedRecoveryAzureNetworkId The selected recovery azure network Id.
 * @property selectedSourceNicId The selected source nic Id which will be used as the primary nic during failover.
 * @property sourceVmCpuCount The CPU count of the VM on the primary side.
 * @property sourceVmRamSizeInMB The RAM size of the VM on the primary side.
 * @property sqlServerLicenseType The SQL Server license type.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetManagedDiskTags The tags for the target managed disks.
 * @property targetNicTags The tags for the target NICs.
 * @property targetProximityPlacementGroupId The target proximity placement group Id.
 * @property targetVmTags The target VM tags.
 * @property useManagedDisks A value indicating whether managed disks should be used during failover.
 * @property vmId The virtual machine Id.
 * @property vmNics The PE Network details.
 * @property vmProtectionState The protection state for the vm.
 * @property vmProtectionStateDescription The protection state description for the vm.
 */
public data class HyperVReplicaAzureReplicationDetailsResponse(
    public val azureVmDiskDetails: List<AzureVmDiskDetailsResponse>? = null,
    public val enableRdpOnTargetOption: String? = null,
    public val encryption: String? = null,
    public val initialReplicationDetails: InitialReplicationDetailsResponse? = null,
    public val instanceType: String,
    public val lastRecoveryPointReceived: String,
    public val lastReplicatedTime: String? = null,
    public val lastRpoCalculatedTime: String? = null,
    public val licenseType: String? = null,
    public val oSDetails: OSDetailsResponse? = null,
    public val protectedManagedDisks: List<HyperVReplicaAzureManagedDiskDetailsResponse>? = null,
    public val recoveryAvailabilitySetId: String? = null,
    public val recoveryAzureLogStorageAccountId: String? = null,
    public val recoveryAzureResourceGroupId: String? = null,
    public val recoveryAzureStorageAccount: String? = null,
    public val recoveryAzureVMSize: String? = null,
    public val recoveryAzureVmName: String? = null,
    public val rpoInSeconds: Double? = null,
    public val seedManagedDiskTags: Map<String, String>? = null,
    public val selectedRecoveryAzureNetworkId: String? = null,
    public val selectedSourceNicId: String? = null,
    public val sourceVmCpuCount: Int? = null,
    public val sourceVmRamSizeInMB: Int? = null,
    public val sqlServerLicenseType: String? = null,
    public val targetAvailabilityZone: String? = null,
    public val targetManagedDiskTags: Map<String, String>? = null,
    public val targetNicTags: Map<String, String>? = null,
    public val targetProximityPlacementGroupId: String? = null,
    public val targetVmTags: Map<String, String>? = null,
    public val useManagedDisks: String? = null,
    public val vmId: String? = null,
    public val vmNics: List<VMNicDetailsResponse>? = null,
    public val vmProtectionState: String? = null,
    public val vmProtectionStateDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVReplicaAzureReplicationDetailsResponse): HyperVReplicaAzureReplicationDetailsResponse = HyperVReplicaAzureReplicationDetailsResponse(
            azureVmDiskDetails = javaType.azureVmDiskDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.AzureVmDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            enableRdpOnTargetOption = javaType.enableRdpOnTargetOption().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 -> args0 }).orElse(null),
            initialReplicationDetails = javaType.initialReplicationDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InitialReplicationDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceType = javaType.instanceType(),
            lastRecoveryPointReceived = javaType.lastRecoveryPointReceived(),
            lastReplicatedTime = javaType.lastReplicatedTime().map({ args0 -> args0 }).orElse(null),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            oSDetails = javaType.oSDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.OSDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protectedManagedDisks = javaType.protectedManagedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HyperVReplicaAzureManagedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            recoveryAvailabilitySetId = javaType.recoveryAvailabilitySetId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureLogStorageAccountId = javaType.recoveryAzureLogStorageAccountId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureResourceGroupId = javaType.recoveryAzureResourceGroupId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureStorageAccount = javaType.recoveryAzureStorageAccount().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureVMSize = javaType.recoveryAzureVMSize().map({ args0 -> args0 }).orElse(null),
            recoveryAzureVmName = javaType.recoveryAzureVmName().map({ args0 -> args0 }).orElse(null),
            rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            seedManagedDiskTags = javaType.seedManagedDiskTags().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            selectedRecoveryAzureNetworkId = javaType.selectedRecoveryAzureNetworkId().map({ args0 ->
                args0
            }).orElse(null),
            selectedSourceNicId = javaType.selectedSourceNicId().map({ args0 -> args0 }).orElse(null),
            sourceVmCpuCount = javaType.sourceVmCpuCount().map({ args0 -> args0 }).orElse(null),
            sourceVmRamSizeInMB = javaType.sourceVmRamSizeInMB().map({ args0 -> args0 }).orElse(null),
            sqlServerLicenseType = javaType.sqlServerLicenseType().map({ args0 -> args0 }).orElse(null),
            targetAvailabilityZone = javaType.targetAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            targetManagedDiskTags = javaType.targetManagedDiskTags().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            targetNicTags = javaType.targetNicTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetProximityPlacementGroupId = javaType.targetProximityPlacementGroupId().map({ args0 ->
                args0
            }).orElse(null),
            targetVmTags = javaType.targetVmTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            useManagedDisks = javaType.useManagedDisks().map({ args0 -> args0 }).orElse(null),
            vmId = javaType.vmId().map({ args0 -> args0 }).orElse(null),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmProtectionState = javaType.vmProtectionState().map({ args0 -> args0 }).orElse(null),
            vmProtectionStateDescription = javaType.vmProtectionStateDescription().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
