@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * HyperV replica 2012 R2 (Blue) replication details.
 * @property initialReplicationDetails Initial replication details.
 * @property instanceType Gets the Instance type.
 * Expected value is 'HyperVReplica2012R2'.
 * @property lastReplicatedTime The Last replication time.
 * @property vMDiskDetails VM disk details.
 * @property vmId The virtual machine Id.
 * @property vmNics The PE Network details.
 * @property vmProtectionState The protection state for the vm.
 * @property vmProtectionStateDescription The protection state description for the vm.
 */
public data class HyperVReplicaBlueReplicationDetailsResponse(
    public val initialReplicationDetails: InitialReplicationDetailsResponse? = null,
    public val instanceType: String,
    public val lastReplicatedTime: String? = null,
    public val vMDiskDetails: List<DiskDetailsResponse>? = null,
    public val vmId: String? = null,
    public val vmNics: List<VMNicDetailsResponse>? = null,
    public val vmProtectionState: String? = null,
    public val vmProtectionStateDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.HyperVReplicaBlueReplicationDetailsResponse): HyperVReplicaBlueReplicationDetailsResponse = HyperVReplicaBlueReplicationDetailsResponse(
            initialReplicationDetails = javaType.initialReplicationDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InitialReplicationDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceType = javaType.instanceType(),
            lastReplicatedTime = javaType.lastReplicatedTime().map({ args0 -> args0 }).orElse(null),
            vMDiskDetails = javaType.vMDiskDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmId = javaType.vmId().map({ args0 -> args0 }).orElse(null),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmProtectionState = javaType.vmProtectionState().map({ args0 -> args0 }).orElse(null),
            vmProtectionStateDescription = javaType.vmProtectionStateDescription().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
