@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipAddressType
 * @property isPrimary
 * @property isSeletedForFailover
 * @property name
 * @property recoveryIPAddressType
 * @property recoveryLBBackendAddressPoolIds
 * @property recoveryPublicIPAddressId
 * @property recoveryStaticIPAddress
 * @property recoverySubnetName
 * @property staticIPAddress
 * @property subnetName
 * @property tfoLBBackendAddressPoolIds
 * @property tfoPublicIPAddressId
 * @property tfoStaticIPAddress
 * @property tfoSubnetName
 */
public data class IPConfigDetailsResponse(
    public val ipAddressType: String? = null,
    public val isPrimary: Boolean? = null,
    public val isSeletedForFailover: Boolean? = null,
    public val name: String? = null,
    public val recoveryIPAddressType: String? = null,
    public val recoveryLBBackendAddressPoolIds: List<String>? = null,
    public val recoveryPublicIPAddressId: String? = null,
    public val recoveryStaticIPAddress: String? = null,
    public val recoverySubnetName: String? = null,
    public val staticIPAddress: String? = null,
    public val subnetName: String? = null,
    public val tfoLBBackendAddressPoolIds: List<String>? = null,
    public val tfoPublicIPAddressId: String? = null,
    public val tfoStaticIPAddress: String? = null,
    public val tfoSubnetName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.IPConfigDetailsResponse): IPConfigDetailsResponse = IPConfigDetailsResponse(
            ipAddressType = javaType.ipAddressType().map({ args0 -> args0 }).orElse(null),
            isPrimary = javaType.isPrimary().map({ args0 -> args0 }).orElse(null),
            isSeletedForFailover = javaType.isSeletedForFailover().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            recoveryIPAddressType = javaType.recoveryIPAddressType().map({ args0 -> args0 }).orElse(null),
            recoveryLBBackendAddressPoolIds = javaType.recoveryLBBackendAddressPoolIds().map({ args0 ->
                args0
            }),
            recoveryPublicIPAddressId = javaType.recoveryPublicIPAddressId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryStaticIPAddress = javaType.recoveryStaticIPAddress().map({ args0 -> args0 }).orElse(null),
            recoverySubnetName = javaType.recoverySubnetName().map({ args0 -> args0 }).orElse(null),
            staticIPAddress = javaType.staticIPAddress().map({ args0 -> args0 }).orElse(null),
            subnetName = javaType.subnetName().map({ args0 -> args0 }).orElse(null),
            tfoLBBackendAddressPoolIds = javaType.tfoLBBackendAddressPoolIds().map({ args0 -> args0 }),
            tfoPublicIPAddressId = javaType.tfoPublicIPAddressId().map({ args0 -> args0 }).orElse(null),
            tfoStaticIPAddress = javaType.tfoStaticIPAddress().map({ args0 -> args0 }).orElse(null),
            tfoSubnetName = javaType.tfoSubnetName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
