@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * InMageAzureV2 provider specific settings.
 * @property agentExpiryDate Agent expiry date.
 * @property agentVersion The agent version.
 * @property azureVMDiskDetails Azure VM Disk details.
 * @property azureVmGeneration The target generation for this protected item.
 * @property compressedDataRateInMB The compressed data change rate in MB.
 * @property datastores The datastores of the on-premise machine. Value can be list of strings that contain datastore names.
 * @property discoveryType A value indicating the discovery type of the machine. Value can be vCenter or physical.
 * @property diskResized A value indicating whether any disk is resized for this VM.
 * @property enableRdpOnTargetOption The selected option to enable RDP\SSH on target vm after failover. String value of SrsDataContract.EnableRDPOnTargetOption enum.
 * @property firmwareType The firmware type of this protected item.
 * @property infrastructureVmId The infrastructure VM Id.
 * @property instanceType Gets the Instance type.
 * Expected value is 'InMageAzureV2'.
 * @property ipAddress The source IP address.
 * @property isAdditionalStatsAvailable A value indicating whether additional IR stats are available or not.
 * @property isAgentUpdateRequired A value indicating whether installed agent needs to be updated.
 * @property isRebootAfterUpdateRequired A value indicating whether the source server requires a restart after update.
 * @property lastHeartbeat The last heartbeat received from the source server.
 * @property lastRecoveryPointReceived The last recovery point received time.
 * @property lastRpoCalculatedTime The last RPO calculated time.
 * @property lastUpdateReceivedTime The last update time received from on-prem components.
 * @property licenseType License Type of the VM to be used.
 * @property masterTargetId The master target Id.
 * @property multiVmGroupId The multi vm group Id.
 * @property multiVmGroupName The multi vm group name.
 * @property multiVmSyncStatus A value indicating whether multi vm sync is enabled or disabled.
 * @property osDiskId The id of the disk containing the OS.
 * @property osType The type of the OS on the VM.
 * @property osVersion The OS Version of the protected item.
 * @property processServerId The process server Id.
 * @property processServerName The process server name.
 * @property protectedDisks The list of protected disks.
 * @property protectedManagedDisks The list of protected managed disks.
 * @property protectionStage The protection stage.
 * @property recoveryAvailabilitySetId The recovery availability set Id.
 * @property recoveryAzureLogStorageAccountId The ARM id of the log storage account used for replication. This will be set to null if no log storage account was provided during enable protection.
 * @property recoveryAzureResourceGroupId The target resource group Id.
 * @property recoveryAzureStorageAccount The recovery Azure storage account.
 * @property recoveryAzureVMName Recovery Azure given name.
 * @property recoveryAzureVMSize The Recovery Azure VM size.
 * @property replicaId The replica id of the protected item.
 * @property resyncProgressPercentage The resync progress percentage.
 * @property rpoInSeconds The RPO in seconds.
 * @property seedManagedDiskTags The tags for the seed managed disks.
 * @property selectedRecoveryAzureNetworkId The selected recovery azure network Id.
 * @property selectedSourceNicId The selected source nic Id which will be used as the primary nic during failover.
 * @property selectedTfoAzureNetworkId The test failover virtual network.
 * @property sourceVmCpuCount The CPU count of the VM on the primary side.
 * @property sourceVmRamSizeInMB The RAM size of the VM on the primary side.
 * @property sqlServerLicenseType The SQL Server license type.
 * @property switchProviderBlockingErrorDetails The switch provider blocking error information.
 * @property switchProviderDetails The switch provider blocking error information.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetManagedDiskTags The tags for the target managed disks.
 * @property targetNicTags The tags for the target NICs.
 * @property targetProximityPlacementGroupId The target proximity placement group Id.
 * @property targetVmId The ARM Id of the target Azure VM. This value will be null until the VM is failed over. Only after failure it will be populated with the ARM Id of the Azure VM.
 * @property targetVmTags The target VM tags.
 * @property totalDataTransferred The total transferred data in bytes.
 * @property totalProgressHealth The progress health.
 * @property uncompressedDataRateInMB The uncompressed data change rate in MB.
 * @property useManagedDisks A value indicating whether managed disks should be used during failover.
 * @property vCenterInfrastructureId The vCenter infrastructure Id.
 * @property validationErrors The validation errors of the on-premise machine Value can be list of validation errors.
 * @property vhdName The OS disk VHD name.
 * @property vmId The virtual machine Id.
 * @property vmNics The PE Network details.
 * @property vmProtectionState The protection state for the vm.
 * @property vmProtectionStateDescription The protection state description for the vm.
 */
public data class InMageAzureV2ReplicationDetailsResponse(
    public val agentExpiryDate: String? = null,
    public val agentVersion: String? = null,
    public val azureVMDiskDetails: List<AzureVmDiskDetailsResponse>? = null,
    public val azureVmGeneration: String? = null,
    public val compressedDataRateInMB: Double? = null,
    public val datastores: List<String>? = null,
    public val discoveryType: String? = null,
    public val diskResized: String? = null,
    public val enableRdpOnTargetOption: String? = null,
    public val firmwareType: String? = null,
    public val infrastructureVmId: String? = null,
    public val instanceType: String,
    public val ipAddress: String? = null,
    public val isAdditionalStatsAvailable: Boolean? = null,
    public val isAgentUpdateRequired: String? = null,
    public val isRebootAfterUpdateRequired: String? = null,
    public val lastHeartbeat: String? = null,
    public val lastRecoveryPointReceived: String,
    public val lastRpoCalculatedTime: String? = null,
    public val lastUpdateReceivedTime: String? = null,
    public val licenseType: String? = null,
    public val masterTargetId: String? = null,
    public val multiVmGroupId: String? = null,
    public val multiVmGroupName: String? = null,
    public val multiVmSyncStatus: String? = null,
    public val osDiskId: String? = null,
    public val osType: String? = null,
    public val osVersion: String? = null,
    public val processServerId: String? = null,
    public val processServerName: String? = null,
    public val protectedDisks: List<InMageAzureV2ProtectedDiskDetailsResponse>? = null,
    public val protectedManagedDisks: List<InMageAzureV2ManagedDiskDetailsResponse>? = null,
    public val protectionStage: String? = null,
    public val recoveryAvailabilitySetId: String? = null,
    public val recoveryAzureLogStorageAccountId: String? = null,
    public val recoveryAzureResourceGroupId: String? = null,
    public val recoveryAzureStorageAccount: String? = null,
    public val recoveryAzureVMName: String? = null,
    public val recoveryAzureVMSize: String? = null,
    public val replicaId: String? = null,
    public val resyncProgressPercentage: Int? = null,
    public val rpoInSeconds: Double? = null,
    public val seedManagedDiskTags: Map<String, String>? = null,
    public val selectedRecoveryAzureNetworkId: String? = null,
    public val selectedSourceNicId: String? = null,
    public val selectedTfoAzureNetworkId: String? = null,
    public val sourceVmCpuCount: Int? = null,
    public val sourceVmRamSizeInMB: Int? = null,
    public val sqlServerLicenseType: String? = null,
    public val switchProviderBlockingErrorDetails: List<InMageAzureV2SwitchProviderBlockingErrorDetailsResponse>? = null,
    public val switchProviderDetails: InMageAzureV2SwitchProviderDetailsResponse? = null,
    public val targetAvailabilityZone: String? = null,
    public val targetManagedDiskTags: Map<String, String>? = null,
    public val targetNicTags: Map<String, String>? = null,
    public val targetProximityPlacementGroupId: String? = null,
    public val targetVmId: String? = null,
    public val targetVmTags: Map<String, String>? = null,
    public val totalDataTransferred: Double? = null,
    public val totalProgressHealth: String? = null,
    public val uncompressedDataRateInMB: Double? = null,
    public val useManagedDisks: String? = null,
    public val vCenterInfrastructureId: String? = null,
    public val validationErrors: List<HealthErrorResponse>? = null,
    public val vhdName: String? = null,
    public val vmId: String? = null,
    public val vmNics: List<VMNicDetailsResponse>? = null,
    public val vmProtectionState: String? = null,
    public val vmProtectionStateDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageAzureV2ReplicationDetailsResponse): InMageAzureV2ReplicationDetailsResponse = InMageAzureV2ReplicationDetailsResponse(
            agentExpiryDate = javaType.agentExpiryDate().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            azureVMDiskDetails = javaType.azureVMDiskDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.AzureVmDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            azureVmGeneration = javaType.azureVmGeneration().map({ args0 -> args0 }).orElse(null),
            compressedDataRateInMB = javaType.compressedDataRateInMB().map({ args0 -> args0 }).orElse(null),
            datastores = javaType.datastores().map({ args0 -> args0 }),
            discoveryType = javaType.discoveryType().map({ args0 -> args0 }).orElse(null),
            diskResized = javaType.diskResized().map({ args0 -> args0 }).orElse(null),
            enableRdpOnTargetOption = javaType.enableRdpOnTargetOption().map({ args0 -> args0 }).orElse(null),
            firmwareType = javaType.firmwareType().map({ args0 -> args0 }).orElse(null),
            infrastructureVmId = javaType.infrastructureVmId().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            isAdditionalStatsAvailable = javaType.isAdditionalStatsAvailable().map({ args0 ->
                args0
            }).orElse(null),
            isAgentUpdateRequired = javaType.isAgentUpdateRequired().map({ args0 -> args0 }).orElse(null),
            isRebootAfterUpdateRequired = javaType.isRebootAfterUpdateRequired().map({ args0 ->
                args0
            }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            lastRecoveryPointReceived = javaType.lastRecoveryPointReceived(),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
            lastUpdateReceivedTime = javaType.lastUpdateReceivedTime().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            masterTargetId = javaType.masterTargetId().map({ args0 -> args0 }).orElse(null),
            multiVmGroupId = javaType.multiVmGroupId().map({ args0 -> args0 }).orElse(null),
            multiVmGroupName = javaType.multiVmGroupName().map({ args0 -> args0 }).orElse(null),
            multiVmSyncStatus = javaType.multiVmSyncStatus().map({ args0 -> args0 }).orElse(null),
            osDiskId = javaType.osDiskId().map({ args0 -> args0 }).orElse(null),
            osType = javaType.osType().map({ args0 -> args0 }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
            processServerId = javaType.processServerId().map({ args0 -> args0 }).orElse(null),
            processServerName = javaType.processServerName().map({ args0 -> args0 }).orElse(null),
            protectedDisks = javaType.protectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageAzureV2ProtectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            protectedManagedDisks = javaType.protectedManagedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageAzureV2ManagedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            protectionStage = javaType.protectionStage().map({ args0 -> args0 }).orElse(null),
            recoveryAvailabilitySetId = javaType.recoveryAvailabilitySetId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureLogStorageAccountId = javaType.recoveryAzureLogStorageAccountId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureResourceGroupId = javaType.recoveryAzureResourceGroupId().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureStorageAccount = javaType.recoveryAzureStorageAccount().map({ args0 ->
                args0
            }).orElse(null),
            recoveryAzureVMName = javaType.recoveryAzureVMName().map({ args0 -> args0 }).orElse(null),
            recoveryAzureVMSize = javaType.recoveryAzureVMSize().map({ args0 -> args0 }).orElse(null),
            replicaId = javaType.replicaId().map({ args0 -> args0 }).orElse(null),
            resyncProgressPercentage = javaType.resyncProgressPercentage().map({ args0 -> args0 }).orElse(null),
            rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            seedManagedDiskTags = javaType.seedManagedDiskTags().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            selectedRecoveryAzureNetworkId = javaType.selectedRecoveryAzureNetworkId().map({ args0 ->
                args0
            }).orElse(null),
            selectedSourceNicId = javaType.selectedSourceNicId().map({ args0 -> args0 }).orElse(null),
            selectedTfoAzureNetworkId = javaType.selectedTfoAzureNetworkId().map({ args0 ->
                args0
            }).orElse(null),
            sourceVmCpuCount = javaType.sourceVmCpuCount().map({ args0 -> args0 }).orElse(null),
            sourceVmRamSizeInMB = javaType.sourceVmRamSizeInMB().map({ args0 -> args0 }).orElse(null),
            sqlServerLicenseType = javaType.sqlServerLicenseType().map({ args0 -> args0 }).orElse(null),
            switchProviderBlockingErrorDetails = javaType.switchProviderBlockingErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageAzureV2SwitchProviderBlockingErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            switchProviderDetails = javaType.switchProviderDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageAzureV2SwitchProviderDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetAvailabilityZone = javaType.targetAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            targetManagedDiskTags = javaType.targetManagedDiskTags().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            targetNicTags = javaType.targetNicTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetProximityPlacementGroupId = javaType.targetProximityPlacementGroupId().map({ args0 ->
                args0
            }).orElse(null),
            targetVmId = javaType.targetVmId().map({ args0 -> args0 }).orElse(null),
            targetVmTags = javaType.targetVmTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalDataTransferred = javaType.totalDataTransferred().map({ args0 -> args0 }).orElse(null),
            totalProgressHealth = javaType.totalProgressHealth().map({ args0 -> args0 }).orElse(null),
            uncompressedDataRateInMB = javaType.uncompressedDataRateInMB().map({ args0 -> args0 }).orElse(null),
            useManagedDisks = javaType.useManagedDisks().map({ args0 -> args0 }).orElse(null),
            vCenterInfrastructureId = javaType.vCenterInfrastructureId().map({ args0 -> args0 }).orElse(null),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            vhdName = javaType.vhdName().map({ args0 -> args0 }).orElse(null),
            vmId = javaType.vmId().map({ args0 -> args0 }).orElse(null),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmProtectionState = javaType.vmProtectionState().map({ args0 -> args0 }).orElse(null),
            vmProtectionStateDescription = javaType.vmProtectionStateDescription().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
