@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * InMage protected disk details.
 * @property diskCapacityInBytes The disk capacity in bytes.
 * @property diskId The disk id.
 * @property diskName The disk name.
 * @property diskResized A value indicating whether disk is resized.
 * @property fileSystemCapacityInBytes The file system capacity in bytes.
 * @property healthErrorCode The health error code for the disk.
 * @property lastRpoCalculatedTime The last RPO calculated time.
 * @property progressHealth The Progress Health.
 * @property progressStatus The Progress Status.
 * @property protectionStage The protection stage.
 * @property psDataInMB The PS data transit in MB.
 * @property resyncDurationInSeconds The resync duration in seconds.
 * @property resyncLast15MinutesTransferredBytes The resync last 15 minutes transferred bytes.
 * @property resyncLastDataTransferTimeUTC The last data transfer time in UTC.
 * @property resyncProcessedBytes The resync processed bytes.
 * @property resyncProgressPercentage The resync progress percentage.
 * @property resyncRequired A value indicating whether resync is required for this disk.
 * @property resyncStartTime The resync start time.
 * @property resyncTotalTransferredBytes The resync total transferred bytes.
 * @property rpoInSeconds The RPO in seconds.
 * @property sourceDataInMB The source data transit in MB.
 * @property targetDataInMB The target data transit in MB.
 */
public data class InMageProtectedDiskDetailsResponse(
    public val diskCapacityInBytes: Double? = null,
    public val diskId: String? = null,
    public val diskName: String? = null,
    public val diskResized: String? = null,
    public val fileSystemCapacityInBytes: Double? = null,
    public val healthErrorCode: String? = null,
    public val lastRpoCalculatedTime: String? = null,
    public val progressHealth: String? = null,
    public val progressStatus: String? = null,
    public val protectionStage: String? = null,
    public val psDataInMB: Double? = null,
    public val resyncDurationInSeconds: Double? = null,
    public val resyncLast15MinutesTransferredBytes: Double? = null,
    public val resyncLastDataTransferTimeUTC: String? = null,
    public val resyncProcessedBytes: Double? = null,
    public val resyncProgressPercentage: Int? = null,
    public val resyncRequired: String? = null,
    public val resyncStartTime: String? = null,
    public val resyncTotalTransferredBytes: Double? = null,
    public val rpoInSeconds: Double? = null,
    public val sourceDataInMB: Double? = null,
    public val targetDataInMB: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageProtectedDiskDetailsResponse): InMageProtectedDiskDetailsResponse = InMageProtectedDiskDetailsResponse(
            diskCapacityInBytes = javaType.diskCapacityInBytes().map({ args0 -> args0 }).orElse(null),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            diskName = javaType.diskName().map({ args0 -> args0 }).orElse(null),
            diskResized = javaType.diskResized().map({ args0 -> args0 }).orElse(null),
            fileSystemCapacityInBytes = javaType.fileSystemCapacityInBytes().map({ args0 ->
                args0
            }).orElse(null),
            healthErrorCode = javaType.healthErrorCode().map({ args0 -> args0 }).orElse(null),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
            progressHealth = javaType.progressHealth().map({ args0 -> args0 }).orElse(null),
            progressStatus = javaType.progressStatus().map({ args0 -> args0 }).orElse(null),
            protectionStage = javaType.protectionStage().map({ args0 -> args0 }).orElse(null),
            psDataInMB = javaType.psDataInMB().map({ args0 -> args0 }).orElse(null),
            resyncDurationInSeconds = javaType.resyncDurationInSeconds().map({ args0 -> args0 }).orElse(null),
            resyncLast15MinutesTransferredBytes = javaType.resyncLast15MinutesTransferredBytes().map({ args0 ->
                args0
            }).orElse(null),
            resyncLastDataTransferTimeUTC = javaType.resyncLastDataTransferTimeUTC().map({ args0 ->
                args0
            }).orElse(null),
            resyncProcessedBytes = javaType.resyncProcessedBytes().map({ args0 -> args0 }).orElse(null),
            resyncProgressPercentage = javaType.resyncProgressPercentage().map({ args0 -> args0 }).orElse(null),
            resyncRequired = javaType.resyncRequired().map({ args0 -> args0 }).orElse(null),
            resyncStartTime = javaType.resyncStartTime().map({ args0 -> args0 }).orElse(null),
            resyncTotalTransferredBytes = javaType.resyncTotalTransferredBytes().map({ args0 ->
                args0
            }).orElse(null),
            rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            sourceDataInMB = javaType.sourceDataInMB().map({ args0 -> args0 }).orElse(null),
            targetDataInMB = javaType.targetDataInMB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
