@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * InMageRcm source agent upgrade blocking error details.
 * @property errorCode The error code.
 * @property errorMessage The error message.
 * @property errorMessageParameters The error message parameters.
 * @property errorTags The error tags.
 * @property possibleCauses The possible causes.
 * @property recommendedAction The recommended action.
 */
public data class InMageRcmAgentUpgradeBlockingErrorDetailsResponse(
    public val errorCode: String,
    public val errorMessage: String,
    public val errorMessageParameters: Map<String, String>,
    public val errorTags: Map<String, String>,
    public val possibleCauses: String,
    public val recommendedAction: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmAgentUpgradeBlockingErrorDetailsResponse): InMageRcmAgentUpgradeBlockingErrorDetailsResponse =
            InMageRcmAgentUpgradeBlockingErrorDetailsResponse(
                errorCode = javaType.errorCode(),
                errorMessage = javaType.errorMessage(),
                errorMessageParameters = javaType.errorMessageParameters().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                errorTags = javaType.errorTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                possibleCauses = javaType.possibleCauses(),
                recommendedAction = javaType.recommendedAction(),
            )
    }
}
