@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InMageRcmFailback discovered VM details.
 * @property createdTimestamp The SDS created timestamp.
 * @property datastores The list of datastores.
 * @property ipAddresses The list of IP addresses.
 * @property isDeleted A value indicating whether the VM is deleted.
 * @property lastDiscoveryTimeInUtc The last time when SDS information discovered in SRS.
 * @property osName The VM's OS name.
 * @property powerStatus The VM power status.
 * @property updatedTimestamp The SDS updated timestamp.
 * @property vCenterFqdn The VCenter fqdn.
 * @property vCenterId The VCenter Id.
 * @property vmFqdn The VM fqdn.
 * @property vmwareToolsStatus The VMware tools status.
 */
public data class InMageRcmFailbackDiscoveredProtectedVmDetailsResponse(
    public val createdTimestamp: String,
    public val datastores: List<String>,
    public val ipAddresses: List<String>,
    public val isDeleted: Boolean,
    public val lastDiscoveryTimeInUtc: String,
    public val osName: String,
    public val powerStatus: String,
    public val updatedTimestamp: String,
    public val vCenterFqdn: String,
    public val vCenterId: String,
    public val vmFqdn: String,
    public val vmwareToolsStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFailbackDiscoveredProtectedVmDetailsResponse): InMageRcmFailbackDiscoveredProtectedVmDetailsResponse =
            InMageRcmFailbackDiscoveredProtectedVmDetailsResponse(
                createdTimestamp = javaType.createdTimestamp(),
                datastores = javaType.datastores().map({ args0 -> args0 }),
                ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
                isDeleted = javaType.isDeleted(),
                lastDiscoveryTimeInUtc = javaType.lastDiscoveryTimeInUtc(),
                osName = javaType.osName(),
                powerStatus = javaType.powerStatus(),
                updatedTimestamp = javaType.updatedTimestamp(),
                vCenterFqdn = javaType.vCenterFqdn(),
                vCenterId = javaType.vCenterId(),
                vmFqdn = javaType.vmFqdn(),
                vmwareToolsStatus = javaType.vmwareToolsStatus(),
            )
    }
}
