@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InMageRcmFailback mobility agent details.
 * @property agentVersionExpiryDate The agent version expiry date.
 * @property driverVersion The driver version.
 * @property driverVersionExpiryDate The driver version expiry date.
 * @property isUpgradeable A value indicating whether agent is upgradeable or not.
 * @property lastHeartbeatUtc The time of the last heartbeat received from the agent.
 * @property latestUpgradableVersionWithoutReboot The latest upgradeable version available without reboot.
 * @property latestVersion The latest agent version available.
 * @property reasonsBlockingUpgrade The whether update is possible or not.
 * @property version The agent version.
 */
public data class InMageRcmFailbackMobilityAgentDetailsResponse(
    public val agentVersionExpiryDate: String,
    public val driverVersion: String,
    public val driverVersionExpiryDate: String,
    public val isUpgradeable: String,
    public val lastHeartbeatUtc: String,
    public val latestUpgradableVersionWithoutReboot: String,
    public val latestVersion: String,
    public val reasonsBlockingUpgrade: List<String>,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFailbackMobilityAgentDetailsResponse): InMageRcmFailbackMobilityAgentDetailsResponse =
            InMageRcmFailbackMobilityAgentDetailsResponse(
                agentVersionExpiryDate = javaType.agentVersionExpiryDate(),
                driverVersion = javaType.driverVersion(),
                driverVersionExpiryDate = javaType.driverVersionExpiryDate(),
                isUpgradeable = javaType.isUpgradeable(),
                lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
                latestUpgradableVersionWithoutReboot = javaType.latestUpgradableVersionWithoutReboot(),
                latestVersion = javaType.latestVersion(),
                reasonsBlockingUpgrade = javaType.reasonsBlockingUpgrade().map({ args0 -> args0 }),
                version = javaType.version(),
            )
    }
}
