@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * InMageRcmFailback NIC details.
 * @property adapterType The adapter type.
 * @property macAddress The mac address.
 * @property networkName The network name.
 * @property sourceIpAddress The IP address.
 */
public data class InMageRcmFailbackNicDetailsResponse(
    public val adapterType: String,
    public val macAddress: String,
    public val networkName: String,
    public val sourceIpAddress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFailbackNicDetailsResponse): InMageRcmFailbackNicDetailsResponse = InMageRcmFailbackNicDetailsResponse(
            adapterType = javaType.adapterType(),
            macAddress = javaType.macAddress(),
            networkName = javaType.networkName(),
            sourceIpAddress = javaType.sourceIpAddress(),
        )
    }
}
