@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * InMageRcmFailback protected disk details.
 * @property capacityInBytes The disk capacity in bytes.
 * @property dataPendingAtSourceAgentInMB The data pending at source agent in MB.
 * @property dataPendingInLogDataStoreInMB The data pending in log data store in MB.
 * @property diskId The disk Id (reported by source agent).
 * @property diskName The disk name.
 * @property diskUuid The disk Uuid (reported by vCenter).
 * @property irDetails The initial replication details.
 * @property isInitialReplicationComplete A value indicating whether initial replication is complete or not.
 * @property isOSDisk A value indicating whether the disk is the OS disk.
 * @property lastSyncTime The last sync time.
 * @property resyncDetails The resync details.
 */
public data class InMageRcmFailbackProtectedDiskDetailsResponse(
    public val capacityInBytes: Double,
    public val dataPendingAtSourceAgentInMB: Double,
    public val dataPendingInLogDataStoreInMB: Double,
    public val diskId: String,
    public val diskName: String,
    public val diskUuid: String,
    public val irDetails: InMageRcmFailbackSyncDetailsResponse? = null,
    public val isInitialReplicationComplete: String,
    public val isOSDisk: String,
    public val lastSyncTime: String,
    public val resyncDetails: InMageRcmFailbackSyncDetailsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFailbackProtectedDiskDetailsResponse): InMageRcmFailbackProtectedDiskDetailsResponse =
            InMageRcmFailbackProtectedDiskDetailsResponse(
                capacityInBytes = javaType.capacityInBytes(),
                dataPendingAtSourceAgentInMB = javaType.dataPendingAtSourceAgentInMB(),
                dataPendingInLogDataStoreInMB = javaType.dataPendingInLogDataStoreInMB(),
                diskId = javaType.diskId(),
                diskName = javaType.diskName(),
                diskUuid = javaType.diskUuid(),
                irDetails = javaType.irDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmFailbackSyncDetailsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                isInitialReplicationComplete = javaType.isInitialReplicationComplete(),
                isOSDisk = javaType.isOSDisk(),
                lastSyncTime = javaType.lastSyncTime(),
                resyncDetails = javaType.resyncDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmFailbackSyncDetailsResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
