@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InMageRcmFailback provider specific details.
 * @property azureVirtualMachineId The ARM Id of the azure VM.
 * @property discoveredVmDetails The discovered VM information.
 * @property initialReplicationProcessedBytes The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
 * @property initialReplicationProgressHealth The initial replication progress health.
 * @property initialReplicationProgressPercentage The initial replication progress percentage.
 * @property initialReplicationTransferredBytes The initial replication transferred bytes from source VM to target for all selected disks on source VM.
 * @property instanceType Gets the Instance type.
 * Expected value is 'InMageRcmFailback'.
 * @property internalIdentifier The virtual machine internal identifier.
 * @property isAgentRegistrationSuccessfulAfterFailover A value indicating whether agent registration was successful after failover.
 * @property lastPlannedFailoverStartTime The last planned failover start time.
 * @property lastPlannedFailoverStatus The last planned failover status.
 * @property lastUsedPolicyFriendlyName The policy friendly name used by the forward replication.
 * @property lastUsedPolicyId The policy Id used by the forward replication.
 * @property logStorageAccountId The log storage account ARM Id.
 * @property mobilityAgentDetails The mobility agent information.
 * @property multiVmGroupName The multi VM group name.
 * @property osType The type of the OS on the VM.
 * @property protectedDisks The list of protected disks.
 * @property reprotectAgentId The reprotect agent Id.
 * @property reprotectAgentName The reprotect agent name.
 * @property resyncProcessedBytes The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
 * @property resyncProgressHealth The resync progress health.
 * @property resyncProgressPercentage The resync progress percentage.
 * @property resyncRequired A value indicating whether resync is required.
 * @property resyncState The resync state.
 * @property resyncTransferredBytes The resync transferred bytes from source VM to target for all selected disks on source VM.
 * @property targetDataStoreName The target datastore name.
 * @property targetVmName The target VM name.
 * @property targetvCenterId The target vCenter Id.
 * @property vmNics The network details.
 */
public data class InMageRcmFailbackReplicationDetailsResponse(
    public val azureVirtualMachineId: String,
    public val discoveredVmDetails: InMageRcmFailbackDiscoveredProtectedVmDetailsResponse? = null,
    public val initialReplicationProcessedBytes: Double,
    public val initialReplicationProgressHealth: String,
    public val initialReplicationProgressPercentage: Int,
    public val initialReplicationTransferredBytes: Double,
    public val instanceType: String,
    public val internalIdentifier: String,
    public val isAgentRegistrationSuccessfulAfterFailover: Boolean,
    public val lastPlannedFailoverStartTime: String,
    public val lastPlannedFailoverStatus: String,
    public val lastUsedPolicyFriendlyName: String,
    public val lastUsedPolicyId: String,
    public val logStorageAccountId: String,
    public val mobilityAgentDetails: InMageRcmFailbackMobilityAgentDetailsResponse? = null,
    public val multiVmGroupName: String,
    public val osType: String,
    public val protectedDisks: List<InMageRcmFailbackProtectedDiskDetailsResponse>? = null,
    public val reprotectAgentId: String,
    public val reprotectAgentName: String,
    public val resyncProcessedBytes: Double,
    public val resyncProgressHealth: String,
    public val resyncProgressPercentage: Int,
    public val resyncRequired: String,
    public val resyncState: String,
    public val resyncTransferredBytes: Double,
    public val targetDataStoreName: String,
    public val targetVmName: String,
    public val targetvCenterId: String,
    public val vmNics: List<InMageRcmFailbackNicDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmFailbackReplicationDetailsResponse): InMageRcmFailbackReplicationDetailsResponse = InMageRcmFailbackReplicationDetailsResponse(
            azureVirtualMachineId = javaType.azureVirtualMachineId(),
            discoveredVmDetails = javaType.discoveredVmDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmFailbackDiscoveredProtectedVmDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialReplicationProcessedBytes = javaType.initialReplicationProcessedBytes(),
            initialReplicationProgressHealth = javaType.initialReplicationProgressHealth(),
            initialReplicationProgressPercentage = javaType.initialReplicationProgressPercentage(),
            initialReplicationTransferredBytes = javaType.initialReplicationTransferredBytes(),
            instanceType = javaType.instanceType(),
            internalIdentifier = javaType.internalIdentifier(),
            isAgentRegistrationSuccessfulAfterFailover = javaType.isAgentRegistrationSuccessfulAfterFailover(),
            lastPlannedFailoverStartTime = javaType.lastPlannedFailoverStartTime(),
            lastPlannedFailoverStatus = javaType.lastPlannedFailoverStatus(),
            lastUsedPolicyFriendlyName = javaType.lastUsedPolicyFriendlyName(),
            lastUsedPolicyId = javaType.lastUsedPolicyId(),
            logStorageAccountId = javaType.logStorageAccountId(),
            mobilityAgentDetails = javaType.mobilityAgentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmFailbackMobilityAgentDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            multiVmGroupName = javaType.multiVmGroupName(),
            osType = javaType.osType(),
            protectedDisks = javaType.protectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmFailbackProtectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            reprotectAgentId = javaType.reprotectAgentId(),
            reprotectAgentName = javaType.reprotectAgentName(),
            resyncProcessedBytes = javaType.resyncProcessedBytes(),
            resyncProgressHealth = javaType.resyncProgressHealth(),
            resyncProgressPercentage = javaType.resyncProgressPercentage(),
            resyncRequired = javaType.resyncRequired(),
            resyncState = javaType.resyncState(),
            resyncTransferredBytes = javaType.resyncTransferredBytes(),
            targetDataStoreName = javaType.targetDataStoreName(),
            targetVmName = javaType.targetVmName(),
            targetvCenterId = javaType.targetvCenterId(),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmFailbackNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
