@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * InMageRcm protected disk details.
 * @property capacityInBytes The disk capacity in bytes.
 * @property dataPendingAtSourceAgentInMB The data pending at source agent in MB.
 * @property dataPendingInLogDataStoreInMB The data pending in log data store in MB.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM Id.
 * @property diskId The disk Id.
 * @property diskName The disk name.
 * @property diskType The disk type.
 * @property irDetails The initial replication details.
 * @property isInitialReplicationComplete A value indicating whether initial replication is complete or not.
 * @property isOSDisk A value indicating whether the disk is the OS disk.
 * @property logStorageAccountId The log storage account ARM Id.
 * @property resyncDetails The resync details.
 * @property seedBlobUri The uri of the seed blob.
 * @property seedManagedDiskId The ARM Id of the seed managed disk.
 * @property targetManagedDiskId The ARM Id of the target managed disk.
 */
public data class InMageRcmProtectedDiskDetailsResponse(
    public val capacityInBytes: Double,
    public val dataPendingAtSourceAgentInMB: Double,
    public val dataPendingInLogDataStoreInMB: Double,
    public val diskEncryptionSetId: String,
    public val diskId: String,
    public val diskName: String,
    public val diskType: String? = null,
    public val irDetails: InMageRcmSyncDetailsResponse? = null,
    public val isInitialReplicationComplete: String,
    public val isOSDisk: String,
    public val logStorageAccountId: String,
    public val resyncDetails: InMageRcmSyncDetailsResponse? = null,
    public val seedBlobUri: String,
    public val seedManagedDiskId: String,
    public val targetManagedDiskId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmProtectedDiskDetailsResponse): InMageRcmProtectedDiskDetailsResponse = InMageRcmProtectedDiskDetailsResponse(
            capacityInBytes = javaType.capacityInBytes(),
            dataPendingAtSourceAgentInMB = javaType.dataPendingAtSourceAgentInMB(),
            dataPendingInLogDataStoreInMB = javaType.dataPendingInLogDataStoreInMB(),
            diskEncryptionSetId = javaType.diskEncryptionSetId(),
            diskId = javaType.diskId(),
            diskName = javaType.diskName(),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            irDetails = javaType.irDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmSyncDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isInitialReplicationComplete = javaType.isInitialReplicationComplete(),
            isOSDisk = javaType.isOSDisk(),
            logStorageAccountId = javaType.logStorageAccountId(),
            resyncDetails = javaType.resyncDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmSyncDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            seedBlobUri = javaType.seedBlobUri(),
            seedManagedDiskId = javaType.seedManagedDiskId(),
            targetManagedDiskId = javaType.targetManagedDiskId(),
        )
    }
}
