@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * InMageRcm provider specific details.
 * @property agentUpgradeAttemptToVersion The agent version to which last agent upgrade was attempted.
 * @property agentUpgradeBlockingErrorDetails The agent upgrade blocking error information.
 * @property agentUpgradeJobId The agent upgrade job Id.
 * @property agentUpgradeState The agent auto upgrade state.
 * @property allocatedMemoryInMB The allocated memory in MB.
 * @property discoveredVmDetails The discovered VM details.
 * @property discoveryType The type of the discovered VM.
 * @property fabricDiscoveryMachineId The ARM Id of the discovered VM.
 * @property failoverRecoveryPointId The recovery point Id to which the VM was failed over.
 * @property firmwareType The firmware type.
 * @property initialReplicationProcessedBytes The initial replication processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
 * @property initialReplicationProgressHealth The initial replication progress health.
 * @property initialReplicationProgressPercentage The initial replication progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
 * @property initialReplicationTransferredBytes The initial replication transferred bytes from source VM to azure for all selected disks on source VM.
 * @property instanceType Gets the Instance type.
 * Expected value is 'InMageRcm'.
 * @property internalIdentifier The virtual machine internal identifier.
 * @property isAgentRegistrationSuccessfulAfterFailover A value indicating whether agent registration was successful after failover.
 * @property isLastUpgradeSuccessful A value indicating whether last agent upgrade was successful or not.
 * @property lastAgentUpgradeErrorDetails The last agent upgrade error information.
 * @property lastAgentUpgradeType The last agent upgrade type.
 * @property lastRecoveryPointId The last recovery point Id.
 * @property lastRecoveryPointReceived The last recovery point received time.
 * @property lastRpoCalculatedTime The last recovery point objective calculated time.
 * @property lastRpoInSeconds The last recovery point objective value.
 * @property licenseType License Type of the VM to be used.
 * @property mobilityAgentDetails The mobility agent information.
 * @property multiVmGroupName The multi VM group name.
 * @property osType The type of the OS on the VM.
 * @property primaryNicIpAddress The IP address of the primary network interface.
 * @property processServerId The process server Id.
 * @property processServerName The process server name.
 * @property processorCoreCount The processor core count.
 * @property protectedDisks The list of protected disks.
 * @property resyncProcessedBytes The resync processed bytes. This includes sum of total bytes transferred and matched bytes on all selected disks in source VM.
 * @property resyncProgressHealth The resync progress health.
 * @property resyncProgressPercentage The resync progress percentage. This is calculated based on total bytes processed for all disks in the source VM.
 * @property resyncRequired A value indicating whether resync is required.
 * @property resyncState The resync state.
 * @property resyncTransferredBytes The resync transferred bytes from source VM to azure for all selected disks on source VM.
 * @property runAsAccountId The run-as account Id.
 * @property storageAccountId The replication storage account ARM Id. This is applicable only for the blob based replication test hook.
 * @property targetAvailabilitySetId The target availability set Id.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetBootDiagnosticsStorageAccountId The target boot diagnostics storage account ARM Id.
 * @property targetGeneration The target generation.
 * @property targetLocation The target location.
 * @property targetNetworkId The target network Id.
 * @property targetProximityPlacementGroupId The target proximity placement group Id.
 * @property targetResourceGroupId The target resource group Id.
 * @property targetVmName Target VM name.
 * @property targetVmSize The target VM size.
 * @property testNetworkId The test network Id.
 * @property vmNics The network details.
 */
public data class InMageRcmReplicationDetailsResponse(
    public val agentUpgradeAttemptToVersion: String,
    public val agentUpgradeBlockingErrorDetails: List<InMageRcmAgentUpgradeBlockingErrorDetailsResponse>? = null,
    public val agentUpgradeJobId: String,
    public val agentUpgradeState: String,
    public val allocatedMemoryInMB: Double,
    public val discoveredVmDetails: InMageRcmDiscoveredProtectedVmDetailsResponse? = null,
    public val discoveryType: String,
    public val fabricDiscoveryMachineId: String,
    public val failoverRecoveryPointId: String,
    public val firmwareType: String,
    public val initialReplicationProcessedBytes: Double,
    public val initialReplicationProgressHealth: String,
    public val initialReplicationProgressPercentage: Int,
    public val initialReplicationTransferredBytes: Double,
    public val instanceType: String,
    public val internalIdentifier: String,
    public val isAgentRegistrationSuccessfulAfterFailover: Boolean,
    public val isLastUpgradeSuccessful: String,
    public val lastAgentUpgradeErrorDetails: List<InMageRcmLastAgentUpgradeErrorDetailsResponse>? =
        null,
    public val lastAgentUpgradeType: String,
    public val lastRecoveryPointId: String,
    public val lastRecoveryPointReceived: String,
    public val lastRpoCalculatedTime: String,
    public val lastRpoInSeconds: Double,
    public val licenseType: String? = null,
    public val mobilityAgentDetails: InMageRcmMobilityAgentDetailsResponse? = null,
    public val multiVmGroupName: String,
    public val osType: String,
    public val primaryNicIpAddress: String,
    public val processServerId: String,
    public val processServerName: String,
    public val processorCoreCount: Int,
    public val protectedDisks: List<InMageRcmProtectedDiskDetailsResponse>? = null,
    public val resyncProcessedBytes: Double,
    public val resyncProgressHealth: String,
    public val resyncProgressPercentage: Int,
    public val resyncRequired: String,
    public val resyncState: String,
    public val resyncTransferredBytes: Double,
    public val runAsAccountId: String,
    public val storageAccountId: String,
    public val targetAvailabilitySetId: String? = null,
    public val targetAvailabilityZone: String? = null,
    public val targetBootDiagnosticsStorageAccountId: String? = null,
    public val targetGeneration: String,
    public val targetLocation: String? = null,
    public val targetNetworkId: String? = null,
    public val targetProximityPlacementGroupId: String? = null,
    public val targetResourceGroupId: String? = null,
    public val targetVmName: String? = null,
    public val targetVmSize: String? = null,
    public val testNetworkId: String? = null,
    public val vmNics: List<InMageRcmNicDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmReplicationDetailsResponse): InMageRcmReplicationDetailsResponse = InMageRcmReplicationDetailsResponse(
            agentUpgradeAttemptToVersion = javaType.agentUpgradeAttemptToVersion(),
            agentUpgradeBlockingErrorDetails = javaType.agentUpgradeBlockingErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmAgentUpgradeBlockingErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            agentUpgradeJobId = javaType.agentUpgradeJobId(),
            agentUpgradeState = javaType.agentUpgradeState(),
            allocatedMemoryInMB = javaType.allocatedMemoryInMB(),
            discoveredVmDetails = javaType.discoveredVmDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmDiscoveredProtectedVmDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            discoveryType = javaType.discoveryType(),
            fabricDiscoveryMachineId = javaType.fabricDiscoveryMachineId(),
            failoverRecoveryPointId = javaType.failoverRecoveryPointId(),
            firmwareType = javaType.firmwareType(),
            initialReplicationProcessedBytes = javaType.initialReplicationProcessedBytes(),
            initialReplicationProgressHealth = javaType.initialReplicationProgressHealth(),
            initialReplicationProgressPercentage = javaType.initialReplicationProgressPercentage(),
            initialReplicationTransferredBytes = javaType.initialReplicationTransferredBytes(),
            instanceType = javaType.instanceType(),
            internalIdentifier = javaType.internalIdentifier(),
            isAgentRegistrationSuccessfulAfterFailover = javaType.isAgentRegistrationSuccessfulAfterFailover(),
            isLastUpgradeSuccessful = javaType.isLastUpgradeSuccessful(),
            lastAgentUpgradeErrorDetails = javaType.lastAgentUpgradeErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmLastAgentUpgradeErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            lastAgentUpgradeType = javaType.lastAgentUpgradeType(),
            lastRecoveryPointId = javaType.lastRecoveryPointId(),
            lastRecoveryPointReceived = javaType.lastRecoveryPointReceived(),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime(),
            lastRpoInSeconds = javaType.lastRpoInSeconds(),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            mobilityAgentDetails = javaType.mobilityAgentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmMobilityAgentDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            multiVmGroupName = javaType.multiVmGroupName(),
            osType = javaType.osType(),
            primaryNicIpAddress = javaType.primaryNicIpAddress(),
            processServerId = javaType.processServerId(),
            processServerName = javaType.processServerName(),
            processorCoreCount = javaType.processorCoreCount(),
            protectedDisks = javaType.protectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmProtectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            resyncProcessedBytes = javaType.resyncProcessedBytes(),
            resyncProgressHealth = javaType.resyncProgressHealth(),
            resyncProgressPercentage = javaType.resyncProgressPercentage(),
            resyncRequired = javaType.resyncRequired(),
            resyncState = javaType.resyncState(),
            resyncTransferredBytes = javaType.resyncTransferredBytes(),
            runAsAccountId = javaType.runAsAccountId(),
            storageAccountId = javaType.storageAccountId(),
            targetAvailabilitySetId = javaType.targetAvailabilitySetId().map({ args0 -> args0 }).orElse(null),
            targetAvailabilityZone = javaType.targetAvailabilityZone().map({ args0 -> args0 }).orElse(null),
            targetBootDiagnosticsStorageAccountId = javaType.targetBootDiagnosticsStorageAccountId().map({ args0 ->
                args0
            }).orElse(null),
            targetGeneration = javaType.targetGeneration(),
            targetLocation = javaType.targetLocation().map({ args0 -> args0 }).orElse(null),
            targetNetworkId = javaType.targetNetworkId().map({ args0 -> args0 }).orElse(null),
            targetProximityPlacementGroupId = javaType.targetProximityPlacementGroupId().map({ args0 ->
                args0
            }).orElse(null),
            targetResourceGroupId = javaType.targetResourceGroupId().map({ args0 -> args0 }).orElse(null),
            targetVmName = javaType.targetVmName().map({ args0 -> args0 }).orElse(null),
            targetVmSize = javaType.targetVmSize().map({ args0 -> args0 }).orElse(null),
            testNetworkId = javaType.testNetworkId().map({ args0 -> args0 }).orElse(null),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageRcmNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
