@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * InMageRcm disk level sync details.
 * @property last15MinutesTransferredBytes The bytes transferred in last 15 minutes from source VM to azure.
 * @property lastDataTransferTimeUtc The time of the last data transfer from source VM to azure.
 * @property lastRefreshTime The last refresh time.
 * @property processedBytes The total processed bytes. This includes bytes that are transferred from source VM to azure and matched bytes.
 * @property progressHealth The progress health.
 * @property progressPercentage Progress in percentage. Progress percentage is calculated based on processed bytes.
 * @property startTime The start time.
 * @property transferredBytes The transferred bytes from source VM to azure for the disk.
 */
public data class InMageRcmSyncDetailsResponse(
    public val last15MinutesTransferredBytes: Double,
    public val lastDataTransferTimeUtc: String,
    public val lastRefreshTime: String,
    public val processedBytes: Double,
    public val progressHealth: String,
    public val progressPercentage: Int,
    public val startTime: String,
    public val transferredBytes: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageRcmSyncDetailsResponse): InMageRcmSyncDetailsResponse = InMageRcmSyncDetailsResponse(
            last15MinutesTransferredBytes = javaType.last15MinutesTransferredBytes(),
            lastDataTransferTimeUtc = javaType.lastDataTransferTimeUtc(),
            lastRefreshTime = javaType.lastRefreshTime(),
            processedBytes = javaType.processedBytes(),
            progressHealth = javaType.progressHealth(),
            progressPercentage = javaType.progressPercentage(),
            startTime = javaType.startTime(),
            transferredBytes = javaType.transferredBytes(),
        )
    }
}
