@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * InMage provider specific settings.
 * @property activeSiteType The active location of the VM. If the VM is being protected from Azure, this field will take values from { Azure, OnPrem }. If the VM is being protected between two data-centers, this field will be OnPrem always.
 * @property agentDetails The agent details.
 * @property azureStorageAccountId A value indicating the underlying Azure storage account. If the VM is not running in Azure, this value shall be set to null.
 * @property compressedDataRateInMB The compressed data change rate in MB.
 * @property consistencyPoints The collection of Consistency points.
 * @property datastores The datastores of the on-premise machine Value can be list of strings that contain datastore names.
 * @property discoveryType A value indicating the discovery type of the machine.
 * @property diskResized A value indicating whether any disk is resized for this VM.
 * @property infrastructureVmId The infrastructure VM Id.
 * @property instanceType Gets the Instance type.
 * Expected value is 'InMage'.
 * @property ipAddress The source IP address.
 * @property isAdditionalStatsAvailable A value indicating whether additional IR stats are available or not.
 * @property lastHeartbeat The last heartbeat received from the source server.
 * @property lastRpoCalculatedTime The last RPO calculated time.
 * @property lastUpdateReceivedTime The last update time received from on-prem components.
 * @property masterTargetId The master target Id.
 * @property multiVmGroupId The multi vm group Id, if any.
 * @property multiVmGroupName The multi vm group name, if any.
 * @property multiVmSyncStatus A value indicating whether the multi vm sync is enabled or disabled.
 * @property osDetails The OS details.
 * @property osVersion The OS Version of the protected item.
 * @property processServerId The process server Id.
 * @property protectedDisks The list of protected disks.
 * @property protectionStage The protection stage.
 * @property rebootAfterUpdateStatus A value indicating whether the source server requires a restart after update.
 * @property replicaId The replica id of the protected item.
 * @property resyncDetails The resync details of the machine.
 * @property retentionWindowEnd The retention window end time.
 * @property retentionWindowStart The retention window start time.
 * @property rpoInSeconds The RPO in seconds.
 * @property sourceVmCpuCount The CPU count of the VM on the primary side.
 * @property sourceVmRamSizeInMB The RAM size of the VM on the primary side.
 * @property totalDataTransferred The total transferred data in bytes.
 * @property totalProgressHealth The progress health.
 * @property uncompressedDataRateInMB The uncompressed data change rate in MB.
 * @property vCenterInfrastructureId The vCenter infrastructure Id.
 * @property validationErrors The validation errors of the on-premise machine Value can be list of validation errors.
 * @property vmId The virtual machine Id.
 * @property vmNics The PE Network details.
 * @property vmProtectionState The protection state for the vm.
 * @property vmProtectionStateDescription The protection state description for the vm.
 */
public data class InMageReplicationDetailsResponse(
    public val activeSiteType: String? = null,
    public val agentDetails: InMageAgentDetailsResponse? = null,
    public val azureStorageAccountId: String? = null,
    public val compressedDataRateInMB: Double? = null,
    public val consistencyPoints: Map<String, String>? = null,
    public val datastores: List<String>? = null,
    public val discoveryType: String? = null,
    public val diskResized: String? = null,
    public val infrastructureVmId: String? = null,
    public val instanceType: String,
    public val ipAddress: String? = null,
    public val isAdditionalStatsAvailable: Boolean? = null,
    public val lastHeartbeat: String? = null,
    public val lastRpoCalculatedTime: String? = null,
    public val lastUpdateReceivedTime: String? = null,
    public val masterTargetId: String? = null,
    public val multiVmGroupId: String? = null,
    public val multiVmGroupName: String? = null,
    public val multiVmSyncStatus: String? = null,
    public val osDetails: OSDiskDetailsResponse? = null,
    public val osVersion: String? = null,
    public val processServerId: String? = null,
    public val protectedDisks: List<InMageProtectedDiskDetailsResponse>? = null,
    public val protectionStage: String? = null,
    public val rebootAfterUpdateStatus: String? = null,
    public val replicaId: String? = null,
    public val resyncDetails: InitialReplicationDetailsResponse? = null,
    public val retentionWindowEnd: String? = null,
    public val retentionWindowStart: String? = null,
    public val rpoInSeconds: Double? = null,
    public val sourceVmCpuCount: Int? = null,
    public val sourceVmRamSizeInMB: Int? = null,
    public val totalDataTransferred: Double? = null,
    public val totalProgressHealth: String? = null,
    public val uncompressedDataRateInMB: Double? = null,
    public val vCenterInfrastructureId: String? = null,
    public val validationErrors: List<HealthErrorResponse>? = null,
    public val vmId: String? = null,
    public val vmNics: List<VMNicDetailsResponse>? = null,
    public val vmProtectionState: String? = null,
    public val vmProtectionStateDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageReplicationDetailsResponse): InMageReplicationDetailsResponse = InMageReplicationDetailsResponse(
            activeSiteType = javaType.activeSiteType().map({ args0 -> args0 }).orElse(null),
            agentDetails = javaType.agentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageAgentDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureStorageAccountId = javaType.azureStorageAccountId().map({ args0 -> args0 }).orElse(null),
            compressedDataRateInMB = javaType.compressedDataRateInMB().map({ args0 -> args0 }).orElse(null),
            consistencyPoints = javaType.consistencyPoints().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            datastores = javaType.datastores().map({ args0 -> args0 }),
            discoveryType = javaType.discoveryType().map({ args0 -> args0 }).orElse(null),
            diskResized = javaType.diskResized().map({ args0 -> args0 }).orElse(null),
            infrastructureVmId = javaType.infrastructureVmId().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            isAdditionalStatsAvailable = javaType.isAdditionalStatsAvailable().map({ args0 ->
                args0
            }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            lastRpoCalculatedTime = javaType.lastRpoCalculatedTime().map({ args0 -> args0 }).orElse(null),
            lastUpdateReceivedTime = javaType.lastUpdateReceivedTime().map({ args0 -> args0 }).orElse(null),
            masterTargetId = javaType.masterTargetId().map({ args0 -> args0 }).orElse(null),
            multiVmGroupId = javaType.multiVmGroupId().map({ args0 -> args0 }).orElse(null),
            multiVmGroupName = javaType.multiVmGroupName().map({ args0 -> args0 }).orElse(null),
            multiVmSyncStatus = javaType.multiVmSyncStatus().map({ args0 -> args0 }).orElse(null),
            osDetails = javaType.osDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.OSDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osVersion = javaType.osVersion().map({ args0 -> args0 }).orElse(null),
            processServerId = javaType.processServerId().map({ args0 -> args0 }).orElse(null),
            protectedDisks = javaType.protectedDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageProtectedDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            protectionStage = javaType.protectionStage().map({ args0 -> args0 }).orElse(null),
            rebootAfterUpdateStatus = javaType.rebootAfterUpdateStatus().map({ args0 -> args0 }).orElse(null),
            replicaId = javaType.replicaId().map({ args0 -> args0 }).orElse(null),
            resyncDetails = javaType.resyncDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InitialReplicationDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionWindowEnd = javaType.retentionWindowEnd().map({ args0 -> args0 }).orElse(null),
            retentionWindowStart = javaType.retentionWindowStart().map({ args0 -> args0 }).orElse(null),
            rpoInSeconds = javaType.rpoInSeconds().map({ args0 -> args0 }).orElse(null),
            sourceVmCpuCount = javaType.sourceVmCpuCount().map({ args0 -> args0 }).orElse(null),
            sourceVmRamSizeInMB = javaType.sourceVmRamSizeInMB().map({ args0 -> args0 }).orElse(null),
            totalDataTransferred = javaType.totalDataTransferred().map({ args0 -> args0 }).orElse(null),
            totalProgressHealth = javaType.totalProgressHealth().map({ args0 -> args0 }).orElse(null),
            uncompressedDataRateInMB = javaType.uncompressedDataRateInMB().map({ args0 -> args0 }).orElse(null),
            vCenterInfrastructureId = javaType.vCenterInfrastructureId().map({ args0 -> args0 }).orElse(null),
            validationErrors = javaType.validationErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            vmId = javaType.vmId().map({ args0 -> args0 }).orElse(null),
            vmNics = javaType.vmNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VMNicDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            vmProtectionState = javaType.vmProtectionState().map({ args0 -> args0 }).orElse(null),
            vmProtectionStateDescription = javaType.vmProtectionStateDescription().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
