@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Details about inquired protectable items under a given container.
 * @property errorDetail Error Details if the Status is non-success.
 * @property inquiryDetails Inquiry Details which will have workload specific details.
 * For e.g. - For SQL and oracle this will contain different details.
 * @property status Inquiry Status for this container such as
 * InProgress | Failed | Succeeded
 */
public data class InquiryInfoResponse(
    public val errorDetail: ErrorDetailResponse? = null,
    public val inquiryDetails: List<WorkloadInquiryDetailsResponse>? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InquiryInfoResponse): InquiryInfoResponse = InquiryInfoResponse(
            errorDetail = javaType.errorDetail().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inquiryDetails = javaType.inquiryDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.WorkloadInquiryDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
