@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Validation for inquired protectable items under a given container.
 * @property additionalDetail Error Additional Detail in case the status is non-success.
 * @property errorDetail Error Detail in case the status is non-success.
 * @property protectableItemCount Dictionary to store the count of ProtectableItems with key POType.
 * @property status Status for the Inquiry Validation.
 */
public data class InquiryValidationResponse(
    public val additionalDetail: String,
    public val errorDetail: ErrorDetailResponse? = null,
    public val protectableItemCount: Any,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InquiryValidationResponse): InquiryValidationResponse = InquiryValidationResponse(
            additionalDetail = javaType.additionalDetail(),
            errorDetail = javaType.errorDetail().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protectableItemCount = javaType.protectableItemCount(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
