@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * KPI Resource Health Details
 * @property resourceHealthDetails Resource Health Status
 * @property resourceHealthStatus Resource Health Status
 */
public data class KPIResourceHealthDetailsResponse(
    public val resourceHealthDetails: List<ResourceHealthDetailsResponse>? = null,
    public val resourceHealthStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.KPIResourceHealthDetailsResponse): KPIResourceHealthDetailsResponse = KPIResourceHealthDetailsResponse(
            resourceHealthDetails = javaType.resourceHealthDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ResourceHealthDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            resourceHealthStatus = javaType.resourceHealthStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
